/*:
 * @target MZ
 * @plugindesc プリロード画像を非表示で描画し、GPUアップロードを行うプラグイン
 * @author ChatGPT
 *
 * @command PreloadPicture
 * @text プリロード画像を表示
 * @desc 指定したピクチャ画像を非表示で一度だけ描画します（GPUに転送される）
 *
 * @arg pictureName
 * @text 画像ファイル名
 * @desc プリロードしたい画像のファイル名（拡張子不要）
 * @type file
 * @dir img/pictures
 *
 */

(() => {
  const pluginName = "PreloadPicture";

  PluginManager.registerCommand(pluginName, "PreloadPicture", args => {
    const pictureName = args.pictureName;
    if (!pictureName) return;

    const bitmap = ImageManager.loadPicture(pictureName);

    bitmap.addLoadListener(() => {
      const sprite = new Sprite(bitmap);
      sprite.visible = false;
      SceneManager._scene.addChild(sprite);

      // 自動的に削除（メモリ節約）するなら数秒後にremoveChild
      setTimeout(() => {
        if (SceneManager._scene && SceneManager._scene.children.includes(sprite)) {
          SceneManager._scene.removeChild(sprite);
        }
      }, 3000); // 3秒後に自動で削除（必要に応じて調整）
    });
  });
})();